Window_MenuCommand.prototype.makeCommandList = function () {
    this.addMainCommands();
    this.addFormationCommand();
    this.addOriginalCommands();
    this.addOptionsCommand();
    this.addSaveCommand();
    this.addLoadCommand();
    this.addGameEndCommand();
};


Window_MenuCommand.prototype.addLoadCommand = function () {
    this.addCommand($gameExtraData.extraText[ConfigManager.Language].load, 'load', true);
};

Scene_Menu.prototype.createCommandWindow = function () {
    this._commandWindow = new Window_MenuCommand(0, 0);
    this._commandWindow.setHandler('item', this.commandItem.bind(this));
    this._commandWindow.setHandler('skill', this.commandPersonal.bind(this));
    this._commandWindow.setHandler('equip', this.commandPersonal.bind(this));
    this._commandWindow.setHandler('status', this.commandPersonal.bind(this));
    this._commandWindow.setHandler('formation', this.commandFormation.bind(this));
    this._commandWindow.setHandler('options', this.commandOptions.bind(this));
    this._commandWindow.setHandler('save', this.commandSave.bind(this));
    this._commandWindow.setHandler('load', this.commandLoad.bind(this));
    this._commandWindow.setHandler('gameEnd', this.commandGameEnd.bind(this));
    this._commandWindow.setHandler('cancel', this.popScene.bind(this));
    this.addWindow(this._commandWindow);
};

Scene_Menu.prototype.commandLoad = function () {
    SceneManager.push(Scene_Load);
};

Window_ItemCategory.prototype.makeCommandList = function () {
    this.addCommand(TextManager.item, 'item');
    // this.addCommand(TextManager.weapon, 'weapon');
    // this.addCommand(TextManager.armor, 'armor');
    this.addCommand(TextManager.keyItem, 'keyItem');
};

Window_ItemCategory.prototype.maxCols = function () {
    return 2;
};


Game_Picture.prototype.move = function (origin, x, y, scaleX, scaleY,
    opacity, blendMode, duration) {
    this._origin = origin;
    this._targetX = x;
    this._targetY = y;
    this._targetScaleX = scaleX;
    this._targetScaleY = scaleY;
    this._targetOpacity = opacity;
    this._blendMode = blendMode;
    this._duration = duration;
    this._totalD=duration
    this._originX=this._x
    this._originY=this._y
};

Game_Picture.prototype.updateMove = function () {
    if (this._duration > 0) {
        var d = this._duration;
        this._x = this.calcuNewPoint(true)
        this._y = this.calcuNewPoint(false)
        this._scaleX = (this._scaleX * (d - 1) + this._targetScaleX) / d;
        this._scaleY = (this._scaleY * (d - 1) + this._targetScaleY) / d;
        this._opacity = (this._opacity * (d - 1) + this._targetOpacity) / d;
        this._duration--;
    }
};

Game_Picture.prototype.calcuNewPoint = function (isX) {
    let t = (this._totalD - this._duration) / this._totalD
    if (isX)
        return (this._targetX - this._originX) * Math.sin(t * Math.PI / 2) + this._originX
    return (this._targetY - this._originY) * Math.sin(t * Math.PI / 2) + this._originY
}

Window_Options.prototype.initialize = function () {
    this._newLanguage = ConfigManager.language
    Window_Command.prototype.initialize.call(this, 0, 0);
    this.updatePlacement();
};

Window_Options.prototype.makeCommandList = function () {
    this.addExtraOptions();
    this.addGeneralOptions();
    this.addVolumeOptions();
};

Window_Options.prototype.addExtraOptions = function () {
    this.addCommand($gameExtraData.extraText[ConfigManager.Language].selectLang, 'language');
}

Window_Options.prototype.statusText = function (index) {
    var symbol = this.commandSymbol(index);
    var value = this.getConfigValue(symbol);
    if (this.isVolumeSymbol(symbol)) {
        return this.volumeStatusText(value);
    }
    else if(symbol=='language'){
        return this.languageStatusText(value);
    } 
    else {
        return this.booleanStatusText(value);
    }
};

Window_Options.prototype.languageStatusText = function (value) {
    return value ? '中文':'日本語'
};


Window_Options.prototype.getConfigValue = function (symbol) {
    if (symbol == "language"){
        return this._newLanguage=="CHI"
    }
    return ConfigManager[symbol];
};

Window_Options.prototype.setConfigValue = function (symbol, volume) {
    if (symbol == "language")
        return this._newLanguage = volume ? "CHI" : "JAP"
    ConfigManager[symbol] = volume;
};

Scene_Options.prototype.terminate = function () {
    Scene_MenuBase.prototype.terminate.call(this);
    let newLanguage = this._optionsWindow._newLanguage
    if (newLanguage !=ConfigManager.Language) {
        ConfigManager.Language = newLanguage
    }
    ConfigManager.save();
};

Scene_Menu.prototype.isReady=function(){
    return Scene_Base.prototype.isReady.call(this) && $gameExtraData.resetTextFlag
}

Scene_Menu.prototype.start = function () {
    Scene_MenuBase.prototype.start.call(this);
    this._statusWindow.refresh();
    this._commandWindow.refresh()
};

Scene_Title.prototype.isReady = function () {
    return Scene_Base.prototype.isReady.call(this) && $gameExtraData.resetTextFlag
}

Scene_Title.prototype.start = function () {
    Scene_Base.prototype.start.call(this);
    SceneManager.clearStack();
    this.centerSprite(this._backSprite1);
    this.centerSprite(this._backSprite2);
    this.playTitleMusic();
    this.startFadeIn(this.fadeSpeed(), false);
    this._commandWindow.refresh()
};


// ConfigManager.language ="CHI";

Object.defineProperty(ConfigManager, 'Language', {
    get: function () {
        return this.language
    },
    set: function (value) {
        this.language = value
        $gameExtraData.resetCharacterName(value)
        $gameExtraData.resetSystemText(value)
        $gameExtraData.resetItemText(value)
        $gameExtraData.resetSkillText(value)
        $gameExtraData.resetCurrencyUnit(value)
        PlotManager.refresh()
    },
    configurable: true
});

ConfigManager.makeData = function () {
    var config = {};
    config.language = this.language;
    config.alwaysDash = this.alwaysDash;
    config.commandRemember = this.commandRemember;
    config.bgmVolume = this.bgmVolume;
    config.bgsVolume = this.bgsVolume;
    config.meVolume = this.meVolume;
    config.seVolume = this.seVolume;
    return config;
};

ConfigManager.applyData = function (config) {
    this.language = config["language"]?config["language"]:"CHI";
    this.alwaysDash = this.readFlag(config, 'alwaysDash');
    this.commandRemember = this.readFlag(config, 'commandRemember');
    this.bgmVolume = this.readVolume(config, 'bgmVolume');
    this.bgsVolume = this.readVolume(config, 'bgsVolume');
    this.meVolume = this.readVolume(config, 'meVolume');
    this.seVolume = this.readVolume(config, 'seVolume');
};

Game_Party.prototype.maxItems = function (item) {
    if (item.meta.Limit)
        return item.meta.Limit
    return 99
};


Game_Troop.prototype.makeDropItems = function () {
    var result = []
    let data = this.deadMembers().reduce(function (r, enemy) {
        if (enemy.enemy().meta.Drop) 
            return r.concat(enemy.enemy().meta.Drop.split(' '));
        return r
    }, []);
    for (let i = 0; i < data.length; i += 2) {
        let id = data[i]
        let number = parseInt(data[i + 1])
        let index = result.findIndex(item => item.id == id)
        if (index == -1)
            result.push({ id: id, number: number })
        else
            result[index].number += number
    }
    let dataRan = this.deadMembers().reduce(function (r, enemy) {
        if (enemy.enemy().meta.DropRan)
            return r.concat(enemy.enemy().meta.DropRan.split(' '));
        return r
    }, []);
    for (let i = 0; i < dataRan.length; i += 3) {
        let id = dataRan[i]
        let number = parseInt(dataRan[i + 1]) + Math.floor(Math.random() * parseInt(dataRan[i+2]))
        let index = result.findIndex(item => item.id == id)
        if (index == -1)
            result.push({ id: id, number: number })
        else
            result[index].number += number
    }
    return result
};

BattleManager.gainDropItems = function () {
    var items = this._rewards.items;
    items.forEach(function (item) {
        $gameParty.gainItem($dataItems[item.id],item.number);
    });
};

BattleManager.displayDropItems = function () {
    var items = this._rewards.items;
    if (items.length > 0) {
        $gameMessage.newPage();
        items.forEach(function (item) {
            $gameMessage.add(TextManager.obtainItem.format($dataItems[item.id].name, item.number));
        });
    }
};

/*
Game_Enemy.prototype.makeDropItems = function () {
    var result=[]
    let data =  this.enemy().meta.Drop.split(' ')
    for(let i=0;i<data.length;i+=2){
        let id = data[i]
        let number = data[i + 1]
        let index=result.findIndex(item => item.id == id)
        if(index==-1)
            result.add({id:id,number:number})
        else 
            result[index].number+=number
    }
    return result
};
*/

Scene_Boot.prototype.start = function () {
    Scene_Base.prototype.start.call(this);
    SoundManager.preloadImportantSounds();
    if (DataManager.isBattleTest()) {
        DataManager.setupBattleTest();
        SceneManager.goto(Scene_Battle);
    } else if (DataManager.isEventTest()) {
        DataManager.setupEventTest();
        SceneManager.goto(Scene_Map);
    } else {
        this.checkPlayerLocation();
        DataManager.setupNewGame();
        SceneManager.goto(Scene_Title);
        Window_TitleCommand.initCommandPosition();
    }
    this.updateDocumentTitle();
    $gameExtraData.resetSystemText(ConfigManager.language)
    $gameExtraData.resetItemText(ConfigManager.language)
    $gameExtraData.resetSkillText(ConfigManager.language)
    PlotManager.refresh()
};

Game_System.prototype.onBattleWin = function () {
    this._winCount++;
    $gameExtraData.refreshHenShin()

};

Game_System.prototype.onBattleEscape = function () {
    this._escapeCount++;
    $gameExtraData.refreshHenShin()
};


Game_ExtraData.prototype.refreshHenShin = function () {
    if($gameSwitches.value(131)||$gameSwitches.value(130)){
        return
    }
    if ($gameSwitches.value(103) == true) {
        let actor = $gameActors.actor(1)
        actor.learnSkill(20)
        actor.forgetSkill(30)
        $gameSwitches.setValue(101, false)
        $gameSwitches.setValue(102, true)
        $gameSwitches.setValue(103, false)
        $gameActors.actor(1).setName("里花")
        $gameActors.actor(1).setCharacterImage("nohenshin", 0)
        $gamePlayer.refresh()
    }
}

Game_Interpreter.prototype.command204 = function () {
    if (!$gameParty.inBattle()) {
        this.setWaitMode('scroll');
        $gameMap.startScroll(this._params[0], this._params[1], this._params[2]);
    }
    return true;
};


Game_Actor.prototype.equipSlots = function () {
    var slots = [];
    for(let i=0;i<3;i++){
        slots.push(2)
    }
    return slots;
};


Window_Gold.prototype.value = function () {
    if ($gameParty._items["3"])
        return $gameParty._items["3"];
    return 0
};

Scene_Shop.prototype.doBuy = function (number) {
    $gameParty.loseItem($dataItems[3],number * this.buyingPrice());
    $gameParty.gainItem(this._item, number);
};

Game_Player.prototype.characterIndex = function() {
    if($gameSwitches.value(123))
    return this._characterIndex+4
    if($gameSwitches.value(101)&&($gameSwitches.value(131)||$gameSwitches.value(132)))
    return this._characterIndex+5
    return this._characterIndex;
};



(function() {
    var _Scene_Load_onLoadSuccess = Scene_Load.prototype.onLoadSuccess;
    Scene_Load.prototype.onLoadSuccess = function() {
        _Scene_Load_onLoadSuccess.call(this);
        var lang = ConfigManager.language || "CHI";
        ConfigManager.Language = lang;
    };
})();


(function() {

    Window_SavefileList.prototype.drawGameTitle = function(info, x, y, width) {
        var title = $dataSystem.gameTitle || "";
        this.drawText(title, x, y, width);
    };

    var _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
    DataManager.makeSavefileInfo = function() {
        var info = _DataManager_makeSavefileInfo.call(this);

        // ① 存檔顯示的標題（維持你原本的做法）
        info.title = $dataSystem.gameTitle;

        // ② ★讓存檔縮圖跟隨目前地圖上的玩家行走圖
        if ($gamePlayer && info.characters && info.characters.length > 0) {
            info.characters[0] = [
                $gamePlayer.characterName(),   // 現在玩家用的檔名
                $gamePlayer.characterIndex()   // 現在玩家用的 Index（會吃你 +4 / +5 的判定）
            ];
        }

        return info;
    };

})();